"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const InternalError_1 = __importDefault(require("./InternalError"));
class InternalBrowserError extends InternalError_1.default {
    constructor(parameters) {
        if (parameters.kind === 'internalBrowserError') {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalBrowserError.PATH_TO_DOCS, kind: 'internalError' }));
        }
        else {
            super(Object.assign(Object.assign({}, parameters), { pathToDocs: InternalBrowserError.PATH_TO_DOCS, kind: 'internalErrorWithOrigin' }));
        }
        this.name = 'InternalBrowserOpenLinkError';
    }
}
InternalBrowserError.PATH_TO_DOCS = '/api/js/js-browser';
exports.default = InternalBrowserError;
//# sourceMappingURL=InternalBrowserError.js.map