"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleDisplayMessage = void 0;
const FrontCapability_1 = __importDefault(require("../../../NativeDevice/Front/FrontCapability"));
const AppletDisplayError_1 = __importDefault(require("../Error/AppletDisplayError"));
const ErrorCodes_1 = __importDefault(require("../Error/ErrorCodes"));
function* handleDisplayMessage(messageTypePrefix, data, nativeDriver) {
    switch (data.type) {
        case messageTypePrefix + '.display.supports':
            const result = yield isCapabilitySupported(data, nativeDriver);
            return result;
        default:
            return null;
    }
}
exports.handleDisplayMessage = handleDisplayMessage;
function isCapabilitySupported(data, nativeDriver) {
    return __awaiter(this, void 0, void 0, function* () {
        const capability = FrontCapability_1.default[data.capability];
        if (typeof capability === 'undefined') {
            throw new AppletDisplayError_1.default({
                kind: 'appletDisplayError',
                message: 'Invalid capability',
                code: ErrorCodes_1.default.DISPLAY_CAPABILITY_INVALID,
            });
        }
        const supports = yield nativeDriver.frontSupports(capability);
        return { supports };
    });
}
function* displayHandler({ messageTypePrefix, data, frontDriver }) {
    return yield handleDisplayMessage(messageTypePrefix, data, frontDriver);
}
exports.default = displayHandler;
//# sourceMappingURL=appletDisplayHandler.js.map