"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.currentTimestampEmiting = void 0;
const dateTimeFactory_1 = require("@signageos/lib/dist/DateTime/dateTimeFactory");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const applicationActions_1 = require("@signageos/actions/dist/Application/applicationActions");
const sendAppletMessage_1 = require("../sendAppletMessage");
const effects_1 = require("redux-saga/effects");
function* currentTimestampEmiting(window, messageTypePrefix, getState) {
    yield (0, effects_1.takeEvery)(applicationActions_1.StartApplication, function* () {
        while (true) {
            const currentTimestamp = (0, dateTimeFactory_1.now)().valueOf();
            yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                type: messageTypePrefix + '.date_time.current_timestamp',
                currentTimestamp,
            });
            yield (0, wait_1.default)(3e3);
        }
    });
}
exports.currentTimestampEmiting = currentTimestampEmiting;
//# sourceMappingURL=appletDateTimeSagas.js.map