"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleCommandMessage = void 0;
const effects_1 = require("redux-saga/effects");
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const AppletCommandError_1 = __importDefault(require("../Error/AppletCommandError"));
const ErrorCodes_1 = __importDefault(require("../Error/ErrorCodes"));
function* handleCommandMessage(messageTypePrefix, data, _nativeDriver, appletUid, timingChecksum) {
    switch (data.type) {
        case messageTypePrefix + '.command.dispatch':
            if (typeof data.command.type !== 'string') {
                throw new AppletCommandError_1.default({
                    kind: 'appletCommandError',
                    message: 'Command type must be a string.',
                    code: ErrorCodes_1.default.COMMAND_TYPE_IS_NOT_STRING,
                });
            }
            yield (0, effects_1.put)({
                type: activeAppletActions_1.ActiveAppletDispatchCommand,
                appletUid,
                timingChecksum,
                command: data.command,
            });
            return {};
        default:
            return null;
    }
}
exports.handleCommandMessage = handleCommandMessage;
function* commandHandler({ messageTypePrefix, data, frontDriver, appletUid, timingChecksum, }) {
    return yield handleCommandMessage(messageTypePrefix, data, frontDriver, appletUid, timingChecksum);
}
exports.default = commandHandler;
//# sourceMappingURL=appletCommandHandler.js.map