"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchAppletCommandToApplet = void 0;
const socketActionCreator_1 = require("../../../Socket/socketActionCreator");
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const sendAppletMessage_1 = require("../sendAppletMessage");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Front:Applet:Command:appletCommandDispatchSagas');
function* dispatchAppletCommandToApplet(messageTypePrefix, window, getState, bundledApplet) {
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(activeAppletActions_1.DispatchCommandToApplet, function* (action) {
        try {
            const activeAppletUid = getState().applet.activeAppletUid;
            if (activeAppletUid !== action.appletUid && activeAppletUid !== (bundledApplet === null || bundledApplet === void 0 ? void 0 : bundledApplet.uid)) {
                throw new Error(`Dispatching timing command to applet is not permited because of appletUid ${activeAppletUid} !== ${action.appletUid}`);
            }
            const command = action.command;
            yield (0, sendAppletMessage_1.sendMessageToActiveAppletIfExists)(window, getState, {
                type: messageTypePrefix + '.command.dispatch_to_applet',
                command,
            });
        }
        catch (error) {
            debug('dispatchAppletCommandToApplet failed', error);
        }
    });
}
exports.dispatchAppletCommandToApplet = dispatchAppletCommandToApplet;
//# sourceMappingURL=appletCommandDispatchSagas.js.map