import { IFile } from '../../NativeDevice/fileSystem';
import OfflineCache from '../../OfflineCache/OfflineCache';
export declare class AppletBinaryDownloader {
    private offlineCache;
    private getStaticBaseUrl;
    private appletFileNameHelpers;
    constructor(shortAppletFilesUrl: boolean, offlineCache: OfflineCache, getStaticBaseUrl: () => string);
    getOrDownloadAppletBinaries(appletUid: string, appletVersion: string, isPackage: boolean, frontAppletVersion?: string, appletVersionPostfix?: string, defaultTimingData?: {
        appletUid: string;
        appletVersion: string;
        appletBinaryFile: string;
        appletFrontAppletJsFile: string | undefined;
    }): Promise<{
        appletBinaryFile: IFile | null;
        frontAppletJsFile: IFile | null;
    }>;
    getOrDownloadFrontAppletJsFile(frontAppletVersion: string): Promise<IFile | null>;
    private downloadAppletBinariesToLocalStorage;
    private downloadAppletPackageToLocalStorage;
    private ensurePackageIsDownloaded;
    private ensurePackageIsExtracted;
    private getPackageMainFilePath;
}
export declare function getDefaultAppletBinaries(appletBinaryUriOrPath: string, frontAppletJsUriOrPath: string | undefined, defaultBaseUri: string): {
    appletBinaryFile: IFile;
    frontAppletJsFile: IFile | null;
};
