"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = __importDefault(require("crypto"));
const randomSemver = () => `${Math.floor(Math.random() * 10)}.${Math.floor(Math.random() * 10)}.${Math.floor(Math.random() * 10)}`;
class MockDeviceFirmwareVersionFactory {
    createFirmwareVersion(deviceUid, applicationType, version) {
        return {
            uid: crypto_1.default.randomUUID(),
            deviceUid: deviceUid,
            firmware: {
                applicationType: applicationType,
                createdAt: new Date(),
                uid: crypto_1.default.randomUUID(),
                version: version,
            },
        };
    }
    getFirmwareVersion(deviceUid, applicationType) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.createFirmwareVersion(deviceUid, applicationType, randomSemver());
        });
    }
}
exports.default = MockDeviceFirmwareVersionFactory;
//# sourceMappingURL=MockDeviceFirmwareVersion.js.map