"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWindowHttpHeadFetcher = void 0;
/**
 * Allows fetching remote content headers using `Window.fetch` API.
 */
function createWindowHttpHeadFetcher(window) {
    return (uri, headers) => __awaiter(this, void 0, void 0, function* () {
        const response = yield window.fetch(uri, { headers, method: 'HEAD' });
        const responseHeaders = {};
        response.headers.forEach((value, key) => {
            responseHeaders[key.toLowerCase()] = value;
        });
        return {
            ok: response.ok,
            headers: responseHeaders,
        };
    });
}
exports.createWindowHttpHeadFetcher = createWindowHttpHeadFetcher;
//# sourceMappingURL=httpHeadFetchers.js.map