"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidFileStateError = exports.RootDirectoryIsNotDeletableError = exports.DirectoryIsNotEmptyError = exports.FileIsNotListableError = exports.DirectoryIsNotReadableError = exports.DirectoryIsNotWritableError = exports.FileAlreadyExistsError = exports.FileDoesNotExistError = void 0;
class FileDoesNotExistError extends Error {
    constructor(filePath) {
        super(`File does not exist: ${filePath.storageUnit.type} - ${filePath.filePath}`);
        this.filePath = filePath;
        Object.setPrototypeOf(this, FileDoesNotExistError.prototype);
    }
}
exports.FileDoesNotExistError = FileDoesNotExistError;
class FileAlreadyExistsError extends Error {
    constructor(filePath) {
        super(`File already exists: ${filePath.storageUnit.type} - ${filePath.filePath}`);
        this.filePath = filePath;
        Object.setPrototypeOf(this, FileAlreadyExistsError.prototype);
    }
}
exports.FileAlreadyExistsError = FileAlreadyExistsError;
class DirectoryIsNotWritableError extends Error {
    constructor(filePath) {
        super(`Path is directory that is not writable: ${filePath.storageUnit.type} - ${filePath.filePath}`);
        this.filePath = filePath;
        Object.setPrototypeOf(this, DirectoryIsNotWritableError.prototype);
    }
}
exports.DirectoryIsNotWritableError = DirectoryIsNotWritableError;
class DirectoryIsNotReadableError extends Error {
    constructor(filePath) {
        super(`Path is directory that is not readable: ${filePath.storageUnit.type} - ${filePath.filePath}`);
        this.filePath = filePath;
        Object.setPrototypeOf(this, DirectoryIsNotReadableError.prototype);
    }
}
exports.DirectoryIsNotReadableError = DirectoryIsNotReadableError;
class FileIsNotListableError extends Error {
    constructor(directoryPath) {
        super(`Path is file that is not listable: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
        this.directoryPath = directoryPath;
        Object.setPrototypeOf(this, FileIsNotListableError.prototype);
    }
}
exports.FileIsNotListableError = FileIsNotListableError;
class DirectoryIsNotEmptyError extends Error {
    constructor(directoryPath) {
        super(`Directory is not empty: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
        this.directoryPath = directoryPath;
        Object.setPrototypeOf(this, DirectoryIsNotEmptyError.prototype);
    }
}
exports.DirectoryIsNotEmptyError = DirectoryIsNotEmptyError;
class RootDirectoryIsNotDeletableError extends Error {
    constructor(directoryPath) {
        super(`Root directory is not deletable: ${directoryPath.storageUnit.type} - ${directoryPath.filePath}`);
        this.directoryPath = directoryPath;
        Object.setPrototypeOf(this, RootDirectoryIsNotDeletableError.prototype);
    }
}
exports.RootDirectoryIsNotDeletableError = RootDirectoryIsNotDeletableError;
class InvalidFileStateError extends Error {
    constructor(filePath) {
        super(`Invalid internal state of fileSystem that cannot be resolved: ${filePath.storageUnit.type} - ${filePath.filePath}`);
        this.filePath = filePath;
        Object.setPrototypeOf(this, InvalidFileStateError.prototype);
    }
}
exports.InvalidFileStateError = InvalidFileStateError;
//# sourceMappingURL=errors.js.map