import { IFilePath } from '../NativeDevice/fileSystem';
export declare class FileDoesNotExistError extends Error {
    readonly filePath: IFilePath;
    constructor(filePath: IFilePath);
}
export declare class FileAlreadyExistsError extends Error {
    readonly filePath: IFilePath;
    constructor(filePath: IFilePath);
}
export declare class DirectoryIsNotWritableError extends Error {
    readonly filePath: IFilePath;
    constructor(filePath: IFilePath);
}
export declare class DirectoryIsNotReadableError extends Error {
    readonly filePath: IFilePath;
    constructor(filePath: IFilePath);
}
export declare class FileIsNotListableError extends Error {
    readonly directoryPath: IFilePath;
    constructor(directoryPath: IFilePath);
}
export declare class DirectoryIsNotEmptyError extends Error {
    readonly directoryPath: IFilePath;
    constructor(directoryPath: IFilePath);
}
export declare class RootDirectoryIsNotDeletableError extends Error {
    readonly directoryPath: IFilePath;
    constructor(directoryPath: IFilePath);
}
export declare class InvalidFileStateError extends Error {
    readonly filePath: IFilePath;
    constructor(filePath: IFilePath);
}
