/// <reference types="node" />
import { IStorageUnit, IFilePath, IFile, IHeaders } from '../NativeDevice/fileSystem';
import HashAlgorithm from '../NativeDevice/HashAlgorithm';
import IFileSystem, { IArchiveInfo, ICopyFileOptions, IMoveFileOptions } from '../NativeDevice/IFileSystem';
import { Blob } from 'buffer';
export declare const FAKE_INTERNAL_STORAGE_UNIT: {
    type: string;
    capacity: number;
    freeSpace: number;
    usableSpace: number;
    removable: boolean;
};
export declare const EXISTING_FILE_NAME = "storage/file.txt";
export declare const EXISTING_FILE_REMOTE_URI = "https://example.com/file.txt";
export declare const EXISTING_FILE_CONTENT = "some content";
export declare const EXISTING_FILE_CHECKSUM: {
    crc32: string;
    md5: string;
};
export declare const ERRORS: {
    fileNotFound: string;
    pathIsNotDirectory: string;
    pathIsNotFile: string;
};
export declare function mockFetch(sourceUri: string, _headers?: IHeaders): Promise<{
    status: number;
    ok: boolean;
    text: () => Promise<string>;
    blob: () => Promise<Blob>;
}>;
export declare class StubMemoryFileSystem implements IFileSystem {
    private volume;
    private eventEmitter;
    listStorageUnits(): Promise<IStorageUnit[]>;
    onStorageUnitsChanged(_listener: () => void): void;
    initialize(): Promise<void>;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    getFile(filePath: IFilePath): Promise<(IFile & IFilePath) | null>;
    readFile(filePath: IFilePath): Promise<string>;
    readFileAsBlob(filePath: IFilePath): Promise<Blob>;
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    exists(filePath: IFilePath): Promise<boolean>;
    downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
    writeBlobAsFile(filePath: IFilePath, blob: Blob): Promise<void>;
    uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: IHeaders): Promise<string>;
    onUpload(listener: (filePath: IFilePath, uri: string, formKey: string, headers: {
        [key: string]: string;
    } | undefined, responseCallback: (response: string) => void) => void): void;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
    link(sourceFilePath: IFilePath, destinationFilePath: IFilePath): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
    extractFile(_archiveFilePath: IFilePath, _destinationDirectoryPath: IFilePath, _method: string): Promise<void>;
    createArchive(_archiveFilePath: IFilePath, _archiveEntries: IFilePath[]): Promise<void>;
    getArchiveInfo(_archiveFilePath: IFilePath): Promise<IArchiveInfo>;
    wipeout(): Promise<void>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    private deleteFileRecursive;
    private getAbsolutePath;
}
