import IFrontFileSystem, { IArchiveInfo, ICopyFileOptions, IMoveFileOptions } from '../../NativeDevice/IFileSystem';
import { IFilePath, IFile, IStorageUnit, IHeaders } from '../../NativeDevice/fileSystem';
import HashAlgorithm from '../../NativeDevice/HashAlgorithm';
type MemoryAddress = string & {
    __brand: 'MemoryLocation';
};
declare function MemoryAddress(address?: string): MemoryAddress;
declare enum FileType {
    File = "file",
    Directory = "directory"
}
interface IBaseMetadata {
    parentFilePath: string;
}
interface IFileMetadata extends IBaseMetadata {
    fileType: FileType.File;
    address: MemoryAddress;
}
export declare const DATABASE_PREFIX = "fileSystem";
export default class IndexedDBFileSystem implements IFrontFileSystem {
    private indexedDB;
    private caches;
    private baseUrl;
    private namespace?;
    private db;
    private databaseName;
    private cache;
    constructor(indexedDB: IDBFactory, caches: CacheStorage, baseUrl: string, namespace?: string | undefined);
    initialize(): Promise<void>;
    destroy(): Promise<void>;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    getFile(filePath: IFilePath): Promise<IFile | null>;
    readFile(filePath: IFilePath): Promise<string>;
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    exists(filePath: IFilePath): Promise<boolean>;
    downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
    uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: {
        [key: string]: string;
    }): Promise<string>;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
    link(_sourceFilePath: IFilePath, _destinationFilePath: IFilePath): Promise<void>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
    createArchive(_archiveFilePath: IFilePath, _archiveEntries: IFilePath[]): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
    listStorageUnits(): Promise<IStorageUnit[]>;
    onStorageUnitsChanged(_listener: () => void): void;
    getArchiveInfo(archiveFilePath: IFilePath): Promise<IArchiveInfo>;
    readFileAsBlob(filePath: IFilePath): Promise<{
        blob: Blob;
        fileMetadata: IFileMetadata;
    }>;
    writeBlobAsFile(filePath: IFilePath, blob: Blob): Promise<void>;
    wipeout(): Promise<void>;
    private ensureDirectoryRecursive;
    private doRequest;
    private startTransaction;
    private ensureInternalStorageUnit;
    private getMemoryType;
    private getParentFilePath;
    private createLocalUri;
    private createLocalUriWithBaseOrigin;
}
export {};
