import IFileSystem, { IArchiveInfo, ICopyFileOptions, IMoveFileOptions } from '../NativeDevice/IFileSystem';
import { IFilePath, IFile, IHeaders, IStorageUnit } from '../NativeDevice/fileSystem';
import HashAlgorithm from '../NativeDevice/HashAlgorithm';
/**
 * Proxy file system implementation that caches results in memory for better performance
 */
export default class CachedFileSystem implements IFileSystem {
    private fileSystem;
    private identification;
    constructor(fileSystem: IFileSystem, identification: string);
    initialize(): Promise<void>;
    getCacheKey(filePath: IFilePath | null, method: keyof CachedFileSystem): string;
    getParentDirectory(filePath: IFilePath): {
        storageUnit: IStorageUnit;
        filePath: string;
    };
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    readFile(filePath: IFilePath): Promise<string>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    getFile(filePath: IFilePath): Promise<IFile | null>;
    exists(filePath: IFilePath): Promise<boolean>;
    downloadFile(destinationFilePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
    uploadFile(filePath: IFilePath, uri: string, formKey: string, headers?: {
        [key: string]: string;
    }): Promise<string | undefined>;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
    link(sourceFilePath: IFilePath, destinationFilePath: IFilePath): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: HashAlgorithm): Promise<string>;
    extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
    createArchive(archiveFilePath: IFilePath, archiveEntries: IFilePath[]): Promise<void>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    listStorageUnits(): Promise<IStorageUnit[]>;
    getArchiveInfo(archiveFilePath: IFilePath): Promise<IArchiveInfo>;
    onStorageUnitsChanged(listener: () => void): void;
    wipeout(): Promise<void>;
}
