"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.whenResponsible = void 0;
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../DI/dependencyInjection");
const whenResponsible = (requiredResponsibilities, saga) => (0, dependencyInjection_1.withDependencies)(['responsibilities'], function* ({ responsibilities }, ...args) {
    requiredResponsibilities = requiredResponsibilities instanceof Array ? requiredResponsibilities : [requiredResponsibilities];
    if (requiredResponsibilities.every((responsibility) => responsibilities.has(responsibility))) {
        yield (0, effects_1.call)(saga, ...args);
    }
});
exports.whenResponsible = whenResponsible;
//# sourceMappingURL=responsible.js.map