"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.whenFrontCapable = exports.whenCapable = void 0;
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../DI/dependencyInjection");
const whenCapable = (requiredCapabilities, saga) => (0, dependencyInjection_1.withDependencies)(['managementDriver'], function* ({ managementDriver }, ...args) {
    requiredCapabilities = requiredCapabilities instanceof Array ? requiredCapabilities : [requiredCapabilities];
    const capableOfList = yield (0, effects_1.all)(requiredCapabilities.map((cap) => (0, effects_1.call)(() => managementDriver.managementSupports(cap))));
    if (capableOfList.every((capable) => capable)) {
        yield (0, effects_1.call)(saga, ...args);
    }
});
exports.whenCapable = whenCapable;
const whenFrontCapable = (requiredCapabilities, saga) => (0, dependencyInjection_1.withDependencies)(['frontDriver'], function* ({ frontDriver }, ...args) {
    requiredCapabilities = requiredCapabilities instanceof Array ? requiredCapabilities : [requiredCapabilities];
    const capableOfList = yield (0, effects_1.all)(requiredCapabilities.map((cap) => (0, effects_1.call)(() => frontDriver.frontSupports(cap))));
    if (capableOfList.every((capable) => capable)) {
        yield (0, effects_1.call)(saga, ...args);
    }
});
exports.whenFrontCapable = whenFrontCapable;
//# sourceMappingURL=capable.js.map