"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Responsibility;
(function (Responsibility) {
    /**
     * Deprovision the device.
     */
    Responsibility[Responsibility["DEPROVISIONING"] = 0] = "DEPROVISIONING";
    /**
     * Set and report time, time zone, and NTP server.
     */
    Responsibility[Responsibility["TIME"] = 1] = "TIME";
    /**
     * Set and report audio volume.
     */
    Responsibility[Responsibility["VOLUME"] = 2] = "VOLUME";
    /**
     * Control device power.
     */
    Responsibility[Responsibility["POWER"] = 3] = "POWER";
    /**
     * Set and report display brightness.
     */
    Responsibility[Responsibility["BRIGHTNESS"] = 4] = "BRIGHTNESS";
    /**
     * Set and report debugging status.
     */
    Responsibility[Responsibility["DEBUG"] = 5] = "DEBUG";
    /**
     * Kiosk mode typically disables IR Remote Control and prevents users from leaving the app.
     *
     * Control and report kiosk mode. Manage PIN.
     */
    Responsibility[Responsibility["KIOSK"] = 6] = "KIOSK";
    /**
     * Take and report screenshots.
     */
    Responsibility[Responsibility["SCREENSHOT"] = 7] = "SCREENSHOT";
    /**
     * Install and report installed packages.
     */
    Responsibility[Responsibility["PACKAGES"] = 8] = "PACKAGES";
    /**
     * Install firmware updates and report firmware version and type.
     */
    Responsibility[Responsibility["FIRMWARE"] = 9] = "FIRMWARE";
    /**
     * Manage servlets.
     */
    Responsibility[Responsibility["SERVLET"] = 10] = "SERVLET";
    /**
     * Set and report screen resolution and orientation.
     */
    Responsibility[Responsibility["SCREEN"] = 11] = "SCREEN";
    /**
     * Install app updates and report app version.
     */
    Responsibility[Responsibility["APP"] = 12] = "APP";
    /**
     * Report bundled applet uid, version and config.
     */
    Responsibility[Responsibility["BUNDLED_APPLET"] = 13] = "BUNDLED_APPLET";
    /**
     * Set and report power timers.
     */
    Responsibility[Responsibility["TIMERS"] = 14] = "TIMERS";
    /**
     * Set and report power action schedule.
     */
    Responsibility[Responsibility["SCHEDULED_POWER"] = 15] = "SCHEDULED_POWER";
    /**
     * Report device temperature.
     */
    Responsibility[Responsibility["TEMPERATURE"] = 16] = "TEMPERATURE";
    /**
     * Report battery status.
     */
    Responsibility[Responsibility["BATTERY"] = 17] = "BATTERY";
    /**
     * Report storage status.
     */
    Responsibility[Responsibility["STORAGE"] = 18] = "STORAGE";
    /**
     * Report device info.
     */
    Responsibility[Responsibility["DEVICE"] = 19] = "DEVICE";
    /**
     * Report network status.
     */
    Responsibility[Responsibility["NETWORK"] = 20] = "NETWORK";
    /**
     * Collect telemetrics.
     */
    Responsibility[Responsibility["TELEMETRY"] = 21] = "TELEMETRY";
    /**
     * Store device policies.
     */
    Responsibility[Responsibility["POLICY"] = 22] = "POLICY";
    /**
     * Report proxy status.
     */
    Responsibility[Responsibility["PROXY"] = 23] = "PROXY";
    /**
     * Report Wifi strength signal.
     */
    Responsibility[Responsibility["WIFI_STRENGTH"] = 24] = "WIFI_STRENGTH";
    /**
     * Platform specific mechanism to self recovery device.
     */
    Responsibility[Responsibility["AUTO_RECOVERY"] = 25] = "AUTO_RECOVERY";
    /**
     * Platform specific mechanism to recovery devices in LAN.
     */
    Responsibility[Responsibility["PEER_RECOVERY"] = 26] = "PEER_RECOVERY";
    /**
     * Report supported capabilities for management status.
     */
    Responsibility[Responsibility["CAPABILITIES_MANAGEMENT"] = 27] = "CAPABILITIES_MANAGEMENT";
    /**
     * Report extended management url.
     */
    Responsibility[Responsibility["EXTENDED_MANAGEMENT"] = 28] = "EXTENDED_MANAGEMENT";
    /**
     * Report vpn.
     */
    Responsibility[Responsibility["VPN"] = 29] = "VPN";
    /**
     * Control Remote Desktop.
     */
    Responsibility[Responsibility["REMOTE_DESKTOP"] = 30] = "REMOTE_DESKTOP";
    /**
     * Execute custom scripts.
     */
    Responsibility[Responsibility["CUSTOM_SCRIPTS"] = 31] = "CUSTOM_SCRIPTS";
    /**
     * Report active core app modules and their status.
     * ex. Management (CC), Front (CA) etc.
     */
    Responsibility[Responsibility["APP_MODULES"] = 32] = "APP_MODULES";
    /**
     * Automatically control and report connected display with serial ports.
     */
    Responsibility[Responsibility["DISPLAY_MANAGER"] = 33] = "DISPLAY_MANAGER";
    /**
     * Manage cryptographic keys and ability to encrypt/decrypt data.
     */
    Responsibility[Responsibility["SECRET_MANAGEMENT"] = 34] = "SECRET_MANAGEMENT";
})(Responsibility || (Responsibility = {}));
exports.default = Responsibility;
//# sourceMappingURL=Responsibility.js.map