import Responsibility from './Responsibility';
/**
 * Defines a responsibility policy.
 */
export interface IResponsibilities {
    /**
     * Whether a responsibility is had according to this policy.
     * @param responsibility Responsibility to check.
     */
    has(responsibility: Responsibility): boolean;
}
/**
 * Create a responsibility policy having specified responsibilities.
 * @param responsibilities Present responsibilities.
 */
export declare function createPresentResponsibilities(...responsibilities: Responsibility[]): IResponsibilities;
/**
 * Create a responsibility policy having *all other* than specified responsibilities.
 * @param responsibilities Absent responsibilities.
 */
export declare function createAbsentResponsibilities(...responsibilities: Responsibility[]): IResponsibilities;
/**
 * Create a responsibility policy having *all* responsibilities. This may be useful for testing.
 */
export declare function createAllResponsibilities(): IResponsibilities;
/**
 * Create a responsibility policy having *no* responsibilities. This may be useful for testing.
 */
export declare function createNoResponsibilities(): IResponsibilities;
