"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.putExperimental = exports.bindAndTakeEveryOnlyWhenPlatformExperimental = void 0;
const activeAppletActions_1 = require("@signageos/actions/dist/Applet/activeAppletActions");
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
function getExperimentalActionType(actionType) {
    return `sos.experimental.${actionType}`;
}
/**
 * The feature for DispatchCommandToApplet is hijacked for experimental purposes.
 * This function is same as takeEvery, but it will also listen to DispatchCommandToApplet with experimental prefix.
 * So the server can send the experimental action to the client even if it is not implemented on the server yet.
 *
 * To perform the feature from server, send Applet Command (POST https://api.signageos.io/v1/device/:deviceUid/applet/:appletUid/command)
 * in the following format:
 * ```json
 * {
 *    "type": "sos.experimental.<actionType>",
 *    "command": {
 *       "foo": "<foo param>",
 *       "bar": "<bar param>"
 *    }
 * }
 * ```
 *
 * @deprecated Replace usage with `bindAndTakeEveryOnlyWhenPlatform` when the feature is implemented on the server.
 * @deprecated This function is not really deprecated and will not be removed, but the usage should by minimized.
 */
function* bindAndTakeEveryOnlyWhenPlatformExperimental(actionType, callback) {
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(activeAppletActions_1.DispatchCommandToApplet, function* (action) {
        if (action.command.type === getExperimentalActionType(actionType)) {
            yield (0, effects_1.call)(callback, Object.assign(Object.assign({}, action.command), { type: actionType }));
        }
    });
    // For forward compatibility, also listen to the action without the experimental prefix.
    yield (0, socketActionCreator_1.bindAndTakeEveryOnlyWhenPlatform)(actionType, function* (action) {
        yield (0, effects_1.call)(callback, action);
    });
}
exports.bindAndTakeEveryOnlyWhenPlatformExperimental = bindAndTakeEveryOnlyWhenPlatformExperimental;
/**
 * The feature for ActiveAppletDispatchCommand is hijacked for experimental purposes.
 * This function is same as put, but it will also send the action with experimental prefix.
 * So the device can send the experimental action to the server even if it is not implemented on the server yet.
 *
 * To perform the feature from device, get Applet Command (GET https://api.signageos.io/v1/device/:deviceUid/applet/:appletUid/command)
 *
 * @deprecated Replace usage with `put` when the feature is implemented on the server.
 * @deprecated This function is not really deprecated and will not be removed, but the usage should by minimized.
 */
function* putExperimental(action) {
    yield (0, effects_1.put)({
        type: activeAppletActions_1.ActiveAppletDispatchCommand,
        appletUid: '',
        timingChecksum: '',
        command: Object.assign(Object.assign({}, action), { type: getExperimentalActionType(action.type) }),
    });
    // For forward compatibility, also put the action without the experimental prefix.
    yield (0, effects_1.put)(action);
}
exports.putExperimental = putExperimental;
//# sourceMappingURL=experimentalActions.js.map