import { ActiveAppletDispatchCommand } from '@signageos/actions/dist/Applet/activeAppletActions';
/**
 * The feature for DispatchCommandToApplet is hijacked for experimental purposes.
 * This function is same as takeEvery, but it will also listen to DispatchCommandToApplet with experimental prefix.
 * So the server can send the experimental action to the client even if it is not implemented on the server yet.
 *
 * To perform the feature from server, send Applet Command (POST https://api.signageos.io/v1/device/:deviceUid/applet/:appletUid/command)
 * in the following format:
 * ```json
 * {
 *    "type": "sos.experimental.<actionType>",
 *    "command": {
 *       "foo": "<foo param>",
 *       "bar": "<bar param>"
 *    }
 * }
 * ```
 *
 * @deprecated Replace usage with `bindAndTakeEveryOnlyWhenPlatform` when the feature is implemented on the server.
 * @deprecated This function is not really deprecated and will not be removed, but the usage should by minimized.
 */
export declare function bindAndTakeEveryOnlyWhenPlatformExperimental<T extends {
    type: string;
}>(actionType: T['type'], callback: (action: T) => void): Generator<import("redux-saga/effects").ForkEffect<any>, void, unknown>;
/**
 * The feature for ActiveAppletDispatchCommand is hijacked for experimental purposes.
 * This function is same as put, but it will also send the action with experimental prefix.
 * So the device can send the experimental action to the server even if it is not implemented on the server yet.
 *
 * To perform the feature from device, get Applet Command (GET https://api.signageos.io/v1/device/:deviceUid/applet/:appletUid/command)
 *
 * @deprecated Replace usage with `put` when the feature is implemented on the server.
 * @deprecated This function is not really deprecated and will not be removed, but the usage should by minimized.
 */
export declare function putExperimental<T extends {
    type: string;
}>(action: T): Generator<import("redux-saga/effects").PutEffect<ActiveAppletDispatchCommand> | import("redux-saga/effects").PutEffect<T>, void, unknown>;
