"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitForSuccessEventsOrFailEvents = exports.waitForSuccessOrFailEvents = void 0;
/**
 * The same logic as waitForSuccessOrFailEvents of @signageos/lib/dist/Events/eventsHelper.ts
 * however the interface of browser event emitter is different from nodejs event emitter
 */
function waitForSuccessOrFailEvents(eventEmitter, successEvent, failEvent) {
    return waitForSuccessEventsOrFailEvents(eventEmitter, [successEvent], [failEvent]);
}
exports.waitForSuccessOrFailEvents = waitForSuccessOrFailEvents;
/**
 * The same logic as waitForSuccessEventsOrFailEvents of @signageos/lib/dist/Events/eventsHelper.ts
 * however the interface of browser event emitter is different from nodejs event emitter
 */
function waitForSuccessEventsOrFailEvents(eventEmitter, successEvents, failEvents) {
    return new Promise((resolve, reject) => {
        let successListener;
        let failListener;
        successListener = (result) => {
            failEvents.forEach((failedEventType) => eventEmitter.removeEventListener(failedEventType, failListener));
            resolve(result);
        };
        failListener = (error) => {
            successEvents.forEach((successEventType) => eventEmitter.removeEventListener(successEventType, successListener));
            reject(error);
        };
        successEvents.forEach((successEventType) => eventEmitter.addEventListener(successEventType, successListener));
        failEvents.forEach((failedEventType) => eventEmitter.addEventListener(failedEventType, failListener));
    });
}
exports.waitForSuccessEventsOrFailEvents = waitForSuccessEventsOrFailEvents;
//# sourceMappingURL=eventsHelper.js.map