import { ActionsLimit } from '@signageos/common-types/dist/Device/Actions/ActionLimit';
import { ITelemetryIntervals } from '../Device/Configuration/telemetryIntervals';
import { DeviceFeatureFlagRecord } from '../Device/Configuration/featureFlags';
export declare enum SubscriptionType {
    open = "open",
    platform = "platform"
}
interface IConfig {
    baseUrl: string;
    platformUri: string;
    staticBaseUrl: string;
    uploadBaseUrl: string;
    weinreUri: string;
    /**
     * Platform specific remote control server url.
     * For example, the samsung uses MagicInfo URL to connect to remote control server.
     * @deprecated use UpdateExtendedManagementUrl action instead
     */
    extendedManagementUrl: string | null;
    subscriptionType: SubscriptionType;
    checkInterval: number;
    telemetryIntervals?: ITelemetryIntervals | null;
    checkTimeBeforeConnection?: boolean;
    offlineActionsLimits?: ActionsLimit | null;
    featureFlags?: DeviceFeatureFlagRecord | null;
}
export default IConfig;
