"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyDeviceApplicationVersionCommon = exports.notifyDeviceFrontDisplayVersion = exports.notifyDeviceProxyInfo = exports.notifyDeviceInfo = exports.fallbackDeviceRegistration = void 0;
const AuthenticationFailReason_1 = __importDefault(require("@signageos/actions/dist/Authentication/AuthenticationFailReason"));
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const deviceApplicationActions_1 = require("@signageos/actions/dist/Device/Application/deviceApplicationActions");
const deviceFrontDisplayActions_1 = require("@signageos/actions/dist/Device/FrontDisplay/deviceFrontDisplayActions");
const deviceActions_1 = require("@signageos/actions/dist/Device/deviceActions");
const debug_1 = __importDefault(require("debug"));
const effects_1 = require("redux-saga/effects");
const ManagementCapability_1 = __importDefault(require("../NativeDevice/Management/ManagementCapability"));
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const deviceActions_2 = require("./deviceActions");
const debug = (0, debug_1.default)('@signageos/front-display:Device:deviceSaga');
function* fallbackDeviceRegistration(getNativeDriver, autoVerification) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationFailed, function* (action) {
        try {
            if (action.reason === AuthenticationFailReason_1.default.MISSING_DEVICE) {
                const nativeDriver = getNativeDriver();
                const deviceUid = yield nativeDriver.getDeviceUid();
                yield (0, effects_1.put)({
                    type: deviceActions_1.RegisterDevice,
                    uid: deviceUid,
                    applicationType: nativeDriver.getApplicationType(),
                    autoVerification,
                });
            }
        }
        catch (error) {
            console.error('fallbackDeviceRegistration failed', error);
        }
    });
}
exports.fallbackDeviceRegistration = fallbackDeviceRegistration;
function* notifyDeviceInfo(getNativeDriver) {
    try {
        const nativeDriver = getNativeDriver();
        const applicationType = nativeDriver.getApplicationType();
        let deviceModel;
        let serialNumber;
        let brand;
        let osVersion;
        const supportsModel = yield nativeDriver.managementSupports(ManagementCapability_1.default.MODEL);
        if (supportsModel) {
            try {
                deviceModel = yield nativeDriver.systemInfo.getModel();
            }
            catch (error) {
                console.error(error.message);
            }
        }
        const supportSN = yield nativeDriver.managementSupports(ManagementCapability_1.default.SERIAL_NUMBER);
        yield (0, effects_1.put)({ type: deviceActions_2.UpdateSerialNumberSupport, supported: supportSN });
        if (supportSN) {
            try {
                serialNumber = yield nativeDriver.systemInfo.getSerialNumber();
            }
            catch (error) {
                console.error(error.message);
            }
        }
        const supportsBrand = yield nativeDriver.managementSupports(ManagementCapability_1.default.BRAND);
        if (supportsBrand) {
            try {
                brand = yield nativeDriver.systemInfo.getBrand();
            }
            catch (error) {
                console.error(error.message);
            }
        }
        const supportsOsVersion = yield nativeDriver.managementSupports(ManagementCapability_1.default.OS_VERSION);
        if (supportsOsVersion) {
            try {
                osVersion = yield nativeDriver.systemInfo.getOSVersion();
            }
            catch (error) {
                console.error(error.message);
            }
        }
        yield (0, effects_1.put)({
            type: deviceActions_1.UpdateDeviceInfo,
            applicationType,
            model: deviceModel,
            serialNumber: serialNumber,
            brand,
            osVersion,
        });
    }
    catch (error) {
        console.error('notifyDeviceInfo failed', error);
    }
}
exports.notifyDeviceInfo = notifyDeviceInfo;
function* notifyDeviceProxyInfo(getNativeDriver) {
    try {
        const nativeDriver = getNativeDriver();
        const supports = yield nativeDriver.managementSupports(ManagementCapability_1.default.PROXY);
        if (supports) {
            const enabled = yield nativeDriver.proxy.isEnabled();
            const uri = yield nativeDriver.proxy.getConnectedTo();
            yield (0, effects_1.put)({
                type: deviceActions_1.UpdateDeviceInfo,
                proxy: {
                    enabled,
                    uri,
                },
            });
        }
    }
    catch (error) {
        console.error('notifyDeviceProxyInfo failed', error);
    }
}
exports.notifyDeviceProxyInfo = notifyDeviceProxyInfo;
function* notifyDeviceFrontDisplayVersion(frontDisplayVersion) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationSucceed, function* () {
        try {
            yield (0, effects_1.put)({
                type: deviceFrontDisplayActions_1.NotifyDeviceFrontDisplayVersion,
                version: frontDisplayVersion,
            });
        }
        catch (error) {
            console.error('notifyDeviceFrontDisplayVersion failed', error);
        }
    });
}
exports.notifyDeviceFrontDisplayVersion = notifyDeviceFrontDisplayVersion;
function* notifyDeviceApplicationVersionCommon(getNativeDriver, applicationVersion) {
    try {
        const deviceUid = yield getNativeDriver().getDeviceUid();
        try {
            yield (0, effects_1.put)({
                type: deviceApplicationActions_1.NotifyDeviceApplicationVersion,
                deviceUid,
                applicationVersion,
            });
        }
        catch (error) {
            debug('No fixed application version', error);
        }
    }
    catch (error) {
        console.error('notifyDeviceApplicationVersion failed', error);
    }
}
exports.notifyDeviceApplicationVersionCommon = notifyDeviceApplicationVersionCommon;
//# sourceMappingURL=deviceSagas.js.map