"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceVerification = void 0;
const deviceVerificationActions_1 = require("@signageos/actions/dist/Device/Verification/deviceVerificationActions");
const initialState = {
    verificationHash: null,
    verified: null,
};
function deviceVerification(state = initialState, action) {
    switch (action.type) {
        case deviceVerificationActions_1.VerificationHashCreated:
            return Object.assign(Object.assign({}, state), { verificationHash: action.verificationHash, verified: false });
        case deviceVerificationActions_1.VerificationSucceeded:
            return Object.assign(Object.assign({}, state), { verified: true, processDoneOnce: true });
        default:
            return state;
    }
}
exports.deviceVerification = deviceVerification;
//# sourceMappingURL=deviceVerificationReducers.js.map