"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deviceSchedulePowerActionCommon = void 0;
const effects_1 = require("redux-saga/effects");
const devicePowerActions_1 = require("@signageos/actions/dist/Device/Power/devicePowerActions");
const powerActionTimers_1 = require("../../NativeDevice/Power/powerActionTimers");
const applicationActions_1 = require("../../Application/applicationActions");
function* deviceSchedulePowerActionCommon(powerActionTimer, shouldHandle) {
    // Trigger storage migration and drop unsupported power action types.
    yield (0, powerActionTimers_1.unsetByFilter)(powerActionTimer, (rule) => {
        return !shouldHandle(rule.powerType);
    });
    yield powerActionTimer.notifyStart();
    try {
        // Actions need to be bound by consumers.
        yield (0, effects_1.takeEvery)(devicePowerActions_1.SchedulePowerAction, function* (action) {
            try {
                if (!shouldHandle(action.powerType)) {
                    return;
                }
                const { uid } = action, rule = __rest(action, ["uid"]);
                yield powerActionTimer.set(uid, rule);
                yield (0, effects_1.put)({
                    type: devicePowerActions_1.SchedulePowerActionSucceed,
                    uid: action.uid,
                });
            }
            catch (error) {
                yield (0, effects_1.put)({
                    type: devicePowerActions_1.SchedulePowerActionFailed,
                    uid: action.uid,
                });
            }
        });
        yield (0, effects_1.takeEvery)(devicePowerActions_1.CancelScheduledPowerAction, function* (action) {
            try {
                const uid = action.scheduledPowerActionUid;
                yield powerActionTimer.unset(uid);
                yield (0, effects_1.put)({
                    type: devicePowerActions_1.CancelScheduledPowerActionSucceed,
                    uid: action.uid,
                });
            }
            catch (error) {
                yield (0, effects_1.put)({
                    type: devicePowerActions_1.CancelScheduledPowerActionFailed,
                    uid: action.uid,
                });
            }
        });
        yield (0, effects_1.take)(applicationActions_1.StopApplication);
    }
    finally {
        yield powerActionTimer.notifyEnd();
    }
}
exports.deviceSchedulePowerActionCommon = deviceSchedulePowerActionCommon;
//# sourceMappingURL=deviceSchedulePowerActionSagas.js.map