"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkServerTimeWhenRequested = void 0;
const effects_1 = require("redux-saga/effects");
const fetch_1 = require("../../Isomorphic/fetch");
const deviceConfigurationHelper_1 = require("../Configuration/deviceConfigurationHelper");
const CHECK_SERVER_TIME_PERIOD = 10e3;
const MAX_TIMESTAMP_DIFF = 1000 * 3600 * 168; // 1 week
function* checkServerTimeWhenRequested(getNativeDriver, defaultConfig, checkTimeBeforeConnection, getDeviceTimestamp) {
    if (!checkTimeBeforeConnection) {
        return;
    }
    while (true) {
        const configBaseUrl = yield (0, effects_1.call)(deviceConfigurationHelper_1.getConfigurationBaseUrl, getNativeDriver(), defaultConfig);
        const response = yield (0, effects_1.call)(fetch_1.fetch, `${configBaseUrl}/time`);
        const { timestamp: serverTimestamp } = yield (0, effects_1.call)([response, response.json]);
        const deviceTimestamp = yield (0, effects_1.call)(getDeviceTimestamp);
        if (Math.abs(deviceTimestamp - serverTimestamp) < MAX_TIMESTAMP_DIFF) {
            return;
        }
        yield (0, effects_1.delay)(CHECK_SERVER_TIME_PERIOD);
    }
}
exports.checkServerTimeWhenRequested = checkServerTimeWhenRequested;
//# sourceMappingURL=serverTimeCheckerSaga.js.map