"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultFeatureFlags = void 0;
const FeatureFlag_1 = require("@signageos/common-types/dist/Device/FeatureFlag");
function getDefaultDeviceFeatureFlags() {
    return Object.keys(FeatureFlag_1.DeviceFeatureFlag).reduce((prev, current) => {
        // Declaring variable as 'never' and assigning it current value in default branch of switch will prevent us
        // from forgetting to add other feature flags when they are added into DeviceFeatureFlag enum in future
        // @ts-ignore
        let _neverFeatureFlag;
        switch (current) {
            case FeatureFlag_1.DeviceFeatureFlag.ScreenshotCapture:
                prev[FeatureFlag_1.DeviceFeatureFlag.ScreenshotCapture] = true;
                return prev;
            default:
                // tsc will throw error when new feature flag is added, and it's not reflected in this switch
                _neverFeatureFlag = current;
                return prev;
        }
    }, {});
}
exports.defaultFeatureFlags = getDefaultDeviceFeatureFlags();
//# sourceMappingURL=featureFlags.js.map