"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConfigResponseVerified = void 0;
// For browser, the crypto package cannot be used because is polyfilled with crypto-browserify,
// which has different implementation than node.js crypto.
const jsrsasign = __importStar(require("jsrsasign"));
function isConfigResponseVerified(data, publicKey) {
    try {
        const { signature: signatureBase64 } = data, dataWithoutAuth = __rest(data, ["signature"]);
        const signedMessage = JSON.stringify(dataWithoutAuth);
        const sig = new jsrsasign.KJUR.crypto.Signature({
            alg: 'SHA256withRSA',
        });
        sig.init(publicKey);
        sig.updateString(signedMessage);
        const signatureHex = Buffer.from(signatureBase64, 'base64').toString('hex');
        return sig.verify(signatureHex);
    }
    catch (error) {
        console.warn(error);
        return false;
    }
}
exports.isConfigResponseVerified = isConfigResponseVerified;
//# sourceMappingURL=deviceConfigurationVerifier.js.map