export interface ISignedResponse {
    /**
     * Unique random identifier to prvent brute-force attacks on message signature
     */
    responseUid: string;
    /**
     * Signature is generated from PEM-formatted private key and serialized JSON-body of message
     */
    signature: string;
    /**
     * Arbitrary key-value pairs that will be send within response
     */
    [key: string]: any;
}
export declare function isConfigResponseVerified<T extends ISignedResponse>(data: T, publicKey: string): boolean;
