"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkDeviceConfigurationSaga = void 0;
const url = __importStar(require("url"));
const progressiveWait_1 = require("@signageos/lib/dist/Timer/progressiveWait");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const deviceConfigurationVerifier_1 = require("./deviceConfigurationVerifier");
const debug_1 = __importDefault(require("debug"));
const deviceConfigurationActions_1 = require("./deviceConfigurationActions");
const fetch_1 = require("../../Isomorphic/fetch");
const effects_1 = require("redux-saga/effects");
const telemetryIntervals_1 = require("./telemetryIntervals");
const offlineActionsConfiguration_1 = require("./offlineActionsConfiguration");
const featureFlags_1 = require("./featureFlags");
const debug = (0, debug_1.default)('@signageos/front-display:Device:Configuration:deviceConfigurationChecker');
const MIN_CHECK_INTERVAL_MS = 10e3;
/**
 * @param fetchFn For tests only
 */
function* checkDeviceConfigurationSaga(deviceUid, defaultConfig, publicKey, fetchFn = fetch_1.fetch, threadName) {
    let lastConfig = {
        updatedAt: null,
        baseUrl: null,
        platformUri: null,
        socketDriver: null,
        staticBaseUrl: null,
        uploadBaseUrl: null,
        weinreUri: null,
        extendedManagementUrl: null,
        subscriptionType: null,
        checkInterval: null,
        telemetryIntervals: null,
        checkTimeBeforeConnection: false,
        offlineActionsLimits: null,
        featureFlags: null,
    };
    const errorProgressiveWait = (0, progressiveWait_1.createProgressiveWait)(2 * 1e3, 2, 2 * 60e3);
    let tries = 0;
    while (true) {
        try {
            debug(threadName, 'Start checking', { tries });
            const config = yield getConfig(deviceUid, defaultConfig, shouldSkipSsl(tries), publicKey, fetchFn, threadName);
            debug('Retrieved config', config, lastConfig);
            errorProgressiveWait.reset(); // first retries are faster in case of fail
            const isUpdated = config.updatedAt !== lastConfig.updatedAt;
            if (isUpdated ||
                config.baseUrl !== lastConfig.baseUrl ||
                config.platformUri !== lastConfig.platformUri ||
                config.socketDriver !== lastConfig.socketDriver ||
                config.staticBaseUrl !== lastConfig.staticBaseUrl ||
                config.uploadBaseUrl !== lastConfig.uploadBaseUrl ||
                config.subscriptionType !== lastConfig.subscriptionType ||
                config.checkInterval !== lastConfig.checkInterval ||
                config.checkTimeBeforeConnection !== config.checkTimeBeforeConnection ||
                !(0, telemetryIntervals_1.areTelemetryIntervalsSame)(config.telemetryIntervals, lastConfig.telemetryIntervals) ||
                config.offlineActionsLimits !== lastConfig.offlineActionsLimits ||
                config.featureFlags !== lastConfig.featureFlags) {
                debug(threadName, 'Config changed');
                yield (0, effects_1.put)({
                    type: deviceConfigurationActions_1.ConfigurationChanged,
                    config,
                });
                lastConfig = config;
            }
            tries = 0;
            yield (0, wait_1.default)(Math.max(config.checkInterval || 0, MIN_CHECK_INTERVAL_MS));
        }
        catch (error) {
            debug(threadName, 'Checking erred', error);
            yield (0, effects_1.put)({
                type: deviceConfigurationActions_1.ConfigurationCheckFailed,
                error,
            });
            tries++;
            yield errorProgressiveWait.wait();
        }
    }
}
exports.checkDeviceConfigurationSaga = checkDeviceConfigurationSaga;
function getConfig(deviceUid, defaultConfig, noSsl, publicKey, fetchFn, threadName) {
    return __awaiter(this, void 0, void 0, function* () {
        const overrideConfig = yield getOverrideConfig(deviceUid, defaultConfig, noSsl, publicKey, fetchFn, threadName);
        return {
            updatedAt: overrideConfig.updatedAt,
            baseUrl: overrideConfig.baseUrl || defaultConfig.baseUrl,
            platformUri: overrideConfig.platformUri || defaultConfig.platformUri,
            socketDriver: overrideConfig.socketDriver || 'ws',
            staticBaseUrl: overrideConfig.staticBaseUrl || defaultConfig.staticBaseUrl,
            uploadBaseUrl: overrideConfig.uploadBaseUrl || defaultConfig.uploadBaseUrl,
            weinreUri: overrideConfig.weinreUri || defaultConfig.weinreUri,
            extendedManagementUrl: overrideConfig.extendedManagementUrl || defaultConfig.extendedManagementUrl,
            subscriptionType: overrideConfig.subscriptionType || defaultConfig.subscriptionType,
            checkInterval: overrideConfig.checkInterval || defaultConfig.checkInterval,
            telemetryIntervals: overrideConfig.telemetryIntervals || defaultConfig.telemetryIntervals || telemetryIntervals_1.defaultTelemetryIntervals,
            checkTimeBeforeConnection: overrideConfig.checkTimeBeforeConnection || defaultConfig.checkTimeBeforeConnection,
            offlineActionsLimits: overrideConfig.offlineActionsLimits || defaultConfig.offlineActionsLimits || offlineActionsConfiguration_1.defaultActionLimits,
            featureFlags: overrideConfig.featureFlags || defaultConfig.featureFlags || featureFlags_1.defaultFeatureFlags,
        };
    });
}
function getOverrideConfig(deviceUid, defaultConfig, noSsl, publicKey, fetchFn, threadName) {
    return __awaiter(this, void 0, void 0, function* () {
        const uri = getConfigurationUri(defaultConfig.baseUrl, noSsl, deviceUid);
        try {
            debug(threadName, 'Fetching config', uri, { noSsl });
            const resp = yield fetchFn(uri);
            const config = yield resp.json();
            debug(threadName, 'Fetched config', config, { noSsl });
            if (noSsl && (!('signature' in config) || !(0, deviceConfigurationVerifier_1.isConfigResponseVerified)(config, publicKey))) {
                throw new Error('Unverified message from server');
            }
            return {
                updatedAt: config.updatedAt,
                baseUrl: null,
                platformUri: config.platformUri,
                socketDriver: config.socketDriver,
                staticBaseUrl: config.staticBaseUrl,
                uploadBaseUrl: config.uploadBaseUrl,
                weinreUri: config.weinreUri,
                extendedManagementUrl: config.extendedManagementUrl,
                subscriptionType: config.subscriptionType,
                checkInterval: config.checkInterval,
                telemetryIntervals: config.telemetryIntervals,
                checkTimeBeforeConnection: config.checkTimeBeforeConnection,
                offlineActionsLimits: config.offlineActionsLimits,
            };
        }
        catch (error) {
            debug(threadName, 'Erred fetching config', error);
            if (error.request && error.request.status === 404 && typeof error.body === 'object') {
                return {
                    updatedAt: error.body.updatedAt,
                    baseUrl: null,
                    platformUri: error.body.platformUri,
                    socketDriver: error.body.socketDriver,
                    staticBaseUrl: error.body.staticBaseUrl,
                    uploadBaseUrl: error.body.uploadBaseUrl,
                    weinreUri: error.body.weirneUri,
                    extendedManagementUrl: error.body.extendedManagementUrl,
                    subscriptionType: error.body.subscriptionType,
                    checkInterval: error.body.checkInterval,
                    telemetryIntervals: error.body.telemetryIntervals,
                    checkTimeBeforeConnection: error.body.checkTimeBeforeConnection,
                    offlineActionsLimits: error.body.offlineActionsLimits,
                    featureFlags: error.body.featureFlags,
                };
            }
            else {
                throw error;
            }
        }
    });
}
function getConfigurationUri(baseUrl, noSsl, deviceUid) {
    const configUri = `${baseUrl}/configuration/${deviceUid}`;
    if (noSsl) {
        const parsedConfigUri = url.parse(configUri, true);
        parsedConfigUri.protocol = 'http:';
        parsedConfigUri.query.signResponse = '1';
        const signedConfigUri = url.format(parsedConfigUri);
        return signedConfigUri;
    }
    return configUri;
}
function shouldSkipSsl(tries) {
    return (tries + 1) % 3 === 0; // Every third try is HTTP only (to try skip SSL errors)
}
//# sourceMappingURL=deviceConfigurationCheckerSaga.js.map