import ICacheDriver from '../NativeDevice/ICacheDriver';
export interface IDataStorage {
    getValueOrDefault<TValue>(key: string, defaultValue: TValue): Promise<TValue>;
    setValue<TValue>(key: string, value: TValue): Promise<{
        totalSizeBytes: number;
    }>;
    removeValue(key: string): Promise<void>;
    getUsagePercentage(): Promise<number>;
}
declare const createDataStorage: (getNativeDriver: () => ICacheDriver) => IDataStorage;
export default createDataStorage;
