"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dependencyInjection = void 0;
const effects_1 = require("redux-saga/effects");
const dependenciesActions_1 = require("./dependenciesActions");
function* dependencyInjection(staticContainer) {
    let container = Object.assign({}, staticContainer);
    yield (0, effects_1.takeEvery)(dependenciesActions_1.UpdateDIDependency, function* (action) {
        container = Object.assign(Object.assign({}, container), action.dependencies);
        yield (0, effects_1.put)({
            type: dependenciesActions_1.UpdateDIContainer,
            container,
        });
    });
    yield (0, effects_1.takeEvery)(dependenciesActions_1.RequestDIContainer, function* (_action) {
        yield (0, effects_1.put)({
            type: dependenciesActions_1.UpdateDIContainer,
            container,
        });
    });
    yield (0, effects_1.put)({
        type: dependenciesActions_1.UpdateDIContainer,
        container,
    });
}
exports.dependencyInjection = dependencyInjection;
//# sourceMappingURL=dependenciesSaga.js.map