"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.customScriptsSaga = void 0;
const effects_1 = require("redux-saga/effects");
const debug_1 = __importDefault(require("debug"));
const capable_1 = require("../Feature/capable");
const ManagementCapabilities_1 = require("@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities");
const ManagementCapability_1 = __importDefault(require("../NativeDevice/Management/ManagementCapability"));
const dependencyInjection_1 = require("../DI/dependencyInjection");
const deviceCustomScriptActions_1 = require("@signageos/actions/dist/Device/CustomScript/deviceCustomScriptActions");
const Responsibility_1 = __importDefault(require("../Feature/Responsibility"));
const responsible_1 = require("../Feature/responsible");
const CustomScript_1 = require("@signageos/common-types/dist/CustomScript/CustomScript");
const CustomScriptDownloader_1 = require("./CustomScriptDownloader");
const browserRuntime_1 = require("./Runtimes/browserRuntime");
const experimentalActions_1 = require("../Experimental/experimentalActions");
const utils_1 = require("./utils");
const AppletBinaryDownloader_1 = require("../Front/Applet/AppletBinaryDownloader");
const debug = (0, debug_1.default)('@signageos/front-display:CustomScripts:customScriptsSaga');
// observe that the nodejs runtime is executed inside an iframe on BrightSign and Tizen
const POSSIBLE_BROWSER_RUNTIMES = ['browser', 'nodejs'];
exports.customScriptsSaga = (0, responsible_1.whenResponsible)(Responsibility_1.default.CUSTOM_SCRIPTS, (0, capable_1.whenCapable)(ManagementCapabilities_1.ManagementCapabilities.CUSTOM_SCRIPTS, customScriptsSagaDefault));
function* customScriptsSagaDefault(offlineCache) {
    yield (0, effects_1.fork)((0, capable_1.whenCapable)(ManagementCapability_1.default.CUSTOM_SCRIPTS, (0, dependencyInjection_1.withDependencies)(['managementDriver', 'staticBaseUrl'], function* ({ managementDriver, staticBaseUrl }) {
        const getStaticBaseUrl = () => {
            return staticBaseUrl;
        };
        const customScriptDownloader = new CustomScriptDownloader_1.CustomScriptDownloader(offlineCache, getStaticBaseUrl);
        const appletBinaryDownloader = new AppletBinaryDownloader_1.AppletBinaryDownloader(false, offlineCache, getStaticBaseUrl);
        const browserRuntime = new browserRuntime_1.BrowserRuntime();
        // has to be experimental for BC with the first version of the custom scripts
        yield (0, experimentalActions_1.bindAndTakeEveryOnlyWhenPlatformExperimental)(deviceCustomScriptActions_1.ExecuteCustomScript, function* (action) {
            var _a;
            debug('execute custom script', action);
            try {
                let customScriptFile = undefined;
                if ((0, CustomScript_1.isArchiveCustomScript)(action.customScript)) {
                    customScriptFile = yield (_a = customScriptDownloader.getOrDownloadCustomScript(action.customScript.archiveUri, action.customScript.mainFile, action.customScript.md5Checksum)) !== null && _a !== void 0 ? _a : undefined;
                }
                let appletJsFile = undefined;
                if (action.customScript.runtime === 'browser' && action.frontAppletVersion) {
                    appletJsFile = yield appletBinaryDownloader.getOrDownloadFrontAppletJsFile(action.frontAppletVersion);
                }
                debug('customScriptFile', customScriptFile);
                const configuration = yield (0, effects_1.call)(utils_1.getConfiguration, action.configuration, action.encryptedConfigurationFields || [], managementDriver);
                debug('configuration', configuration);
                const result = POSSIBLE_BROWSER_RUNTIMES.includes(action.customScript.runtime)
                    ? yield (0, effects_1.call)(browserRuntime.runScriptInBrowser, managementDriver, action.customScript, configuration, customScriptFile, appletJsFile)
                    : yield (0, effects_1.call)([managementDriver.scripts, managementDriver.scripts.execute], action.customScript, configuration, undefined, customScriptFile);
                debug('result', result);
                // has to be experimental for BC with the first version of the custom scripts
                yield (0, experimentalActions_1.putExperimental)({
                    type: deviceCustomScriptActions_1.ExecuteCustomScriptSucceeded,
                    uid: action.uid,
                    result,
                });
            }
            catch (error) {
                debug('error', error);
                // has to be experimental for BC with the first version of the custom scripts
                yield (0, experimentalActions_1.putExperimental)({
                    type: deviceCustomScriptActions_1.ExecuteCustomScriptFailed,
                    uid: action.uid,
                });
            }
        });
    })));
}
//# sourceMappingURL=customScriptsSaga.js.map