"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrowserRuntime = void 0;
const effects_1 = require("redux-saga/effects");
const dependencyInjection_1 = require("../../DI/dependencyInjection");
const CustomScript_1 = require("@signageos/common-types/dist/CustomScript/CustomScript");
const checksum_1 = require("../../Hash/checksum");
const redux_saga_1 = require("redux-saga");
const sendAppletMessage_1 = __importDefault(require("../../Front/Applet/sendAppletMessage"));
const debug_1 = __importDefault(require("debug"));
const errorHelper_1 = require("../../Front/Applet/Error/errorHelper");
const appletMessageHandler_1 = require("../../Front/Applet/appletMessageHandler");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const BrowserRuntimeHelper_1 = __importDefault(require("./BrowserRuntimeHelper"));
const debug = (0, debug_1.default)('@signageos/front-display:customScriptsSaga');
class BrowserRuntime {
    constructor() {
        this.runScriptInBrowser = this.runScriptInBrowser.bind(this);
        this.bindCustomScriptsMessages = this.bindCustomScriptsMessages.bind(this);
        this.handleCustomScriptsMessage = this.handleCustomScriptsMessage.bind(this);
    }
    *runScriptInBrowser(managementDriver, customScript, configuration, scriptFile, appletJsFile) {
        const iframeId = getIframeUID(customScript);
        if (!iframeId) {
            throw new Error("Iframe's id cannot be generated");
        }
        const messageChannel = (0, redux_saga_1.channel)(redux_saga_1.buffers.dropping(10));
        const messagesHandler = (event) => {
            messageChannel.put(event);
        };
        const bindCustomScriptsMessagesTask = yield (0, effects_1.fork)(this.bindCustomScriptsMessages, messageChannel, window, iframeId);
        try {
            window.addEventListener('message', messagesHandler);
            const result = yield (0, effects_1.call)(this.execute, customScript, configuration, iframeId, managementDriver.platformSpecificAPIs, scriptFile, appletJsFile);
            debug('script executed OK: ' + result);
            return result;
        }
        catch (error) {
            throw error;
        }
        finally {
            yield (0, effects_1.cancel)(bindCustomScriptsMessagesTask);
            window.removeEventListener('message', messagesHandler);
        }
    }
    execute(script, config, iframeId = (0, generator_1.generateUniqueHash)(), platformSpecificAPIs, customScriptFile, appletJsFile) {
        return __awaiter(this, void 0, void 0, function* () {
            if ((0, CustomScript_1.isInlineCustomScript)(script)) {
                debug('ProprietaryScripts.execute: ', script.script);
            }
            else {
                debug('ProprietaryScripts.execute: ', customScriptFile === null || customScriptFile === void 0 ? void 0 : customScriptFile.localUri);
            }
            const postResultID = (0, generator_1.generateUniqueHash)();
            const postResult = (messageResult) => parent.postMessage({ result: messageResult, iframeId, postResultID }, '*');
            let iframe;
            if ((0, CustomScript_1.isInlineCustomScript)(script)) {
                iframe = BrowserRuntimeHelper_1.default.createIframe(`${appletJsFile ? BrowserRuntimeHelper_1.default.wrapScript(appletJsFile.localUri) + BrowserRuntimeHelper_1.default.addConfigToSos() : ''}<script>${script.script}</script>`);
            }
            else {
                if (!customScriptFile) {
                    throw new Error('Custom script file is not provided');
                }
                let wrappedScript = '';
                if (appletJsFile) {
                    wrappedScript += BrowserRuntimeHelper_1.default.wrapScript(appletJsFile.localUri);
                }
                wrappedScript += BrowserRuntimeHelper_1.default.addConfigToSos();
                wrappedScript += BrowserRuntimeHelper_1.default.wrapScript(customScriptFile.localUri);
                iframe = BrowserRuntimeHelper_1.default.createIframe(wrappedScript);
            }
            iframe.id = iframeId;
            const { messageListener, getResult } = BrowserRuntimeHelper_1.default.createMessageHandler(iframeId, postResultID);
            try {
                window.addEventListener('message', messageListener);
                BrowserRuntimeHelper_1.default.appendIframe(iframe);
                // contentWindow is available after appending iframe.
                BrowserRuntimeHelper_1.default.checkIframeWindow(iframe);
                BrowserRuntimeHelper_1.default.injectPlatformSpecificAPIs(iframe, postResult, config, platformSpecificAPIs);
                return yield getResult();
            }
            catch (error) {
                return BrowserRuntimeHelper_1.default.parseError(script, error);
            }
            finally {
                BrowserRuntimeHelper_1.default.performCleanUp(messageListener, iframe);
            }
        });
    }
    *bindCustomScriptsMessages(messageChannel, window, iframeId) {
        const handleCustomScriptsMessage = this.handleCustomScriptsMessage;
        const callback = function* (managementDriver, cacheDriver, applicationVersion, timeStorage, event) {
            try {
                const data = event.data;
                const iframeElement = window.document.getElementById(iframeId);
                if (!iframeElement) {
                    return;
                }
                const invocationUid = data.invocationUid;
                try {
                    const response = yield (0, effects_1.call)(handleCustomScriptsMessage, window, data, managementDriver, cacheDriver, applicationVersion, timeStorage);
                    debug('message OK: ' + data.type, data);
                    yield (0, effects_1.call)(sendAppletMessage_1.default, window, iframeId, Object.assign({ type: 'hug.invocation.success', invocationUid }, response));
                }
                catch (error) {
                    yield (0, effects_1.call)(sendAppletMessage_1.default, window, iframeId, {
                        type: 'hug.invocation.error',
                        invocationUid,
                        error: (0, errorHelper_1.createErrorTransferObject)(error),
                    });
                    debug('message FAILED: ' + data.type, data, error);
                }
            }
            catch (error) {
                debug('bindCustomScriptsMessages failed', error);
            }
        };
        yield (0, effects_1.fork)((0, dependencyInjection_1.withDependencies)(['managementDriver', 'cacheDriver', 'applicationVersion', 'proprietaryTimerStorage'], function* ({ managementDriver, cacheDriver, applicationVersion, proprietaryTimerStorage }) {
            yield (0, effects_1.takeEvery)(messageChannel, callback, managementDriver, cacheDriver, applicationVersion, proprietaryTimerStorage);
        }));
    }
    *handleCustomScriptsMessage(window, data, managementDriver, cacheDriver, applicationVersion, timerStorage) {
        debug('Handling custom script message', data);
        return yield (0, appletMessageHandler_1.handleAppletManagementMessage)({
            data,
            window,
            messageTypePrefix: 'hug',
            managementDriver,
            cacheDriver,
            applicationVersion,
            timerStorage,
        });
    }
}
exports.BrowserRuntime = BrowserRuntime;
function getIframeUID(customScript) {
    if ((0, CustomScript_1.isArchiveCustomScript)(customScript)) {
        return customScript.md5Checksum;
    }
    else {
        return (0, checksum_1.checksumString)(customScript.script + Date.now());
    }
}
//# sourceMappingURL=browserRuntime.js.map