import { CustomScript, CustomScriptResult } from '@signageos/common-types/dist/CustomScript/CustomScript';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
import { Channel, Task } from 'redux-saga';
import IMessage from '../../Front/Applet/IMessage';
import IManagementDriver, { IFrontManagementDriver, IPlatformSpecificAPIs } from '../../NativeDevice/Management/IManagementDriver';
import { IFile } from '../../NativeDevice/fileSystem';
import { HandlerResult } from '../../Front/Applet/IHandler';
import ICacheDriver from '../../NativeDevice/ICacheDriver';
export declare class BrowserRuntime {
    constructor();
    runScriptInBrowser(managementDriver: IManagementDriver & IFrontManagementDriver, customScript: CustomScript, configuration: Record<string, any>, scriptFile?: IFile, appletJsFile?: IFile): Generator<import("redux-saga/effects").CancelEffect | import("redux-saga/effects").ForkEffect<void> | import("redux-saga/effects").CallEffect<{
        stream: {
            data: string;
            pipeline: "error" | "output";
            timestamp: number;
        }[];
        runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
        exitCode: number;
    }>, {
        stream: {
            data: string;
            pipeline: "error" | "output";
            timestamp: number;
        }[];
        runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
        exitCode: number;
    }, Task & {
        stream: {
            data: string;
            pipeline: "error" | "output";
            timestamp: number;
        }[];
        runtime: "browser" | "ps1" | "bash" | "sh" | "nodejs" | "brs";
        exitCode: number;
    }>;
    execute(script: CustomScript, config: Record<string, any>, iframeId: string | undefined, platformSpecificAPIs: IPlatformSpecificAPIs, customScriptFile?: IFile, appletJsFile?: IFile): Promise<CustomScriptResult>;
    bindCustomScriptsMessages(messageChannel: Channel<MessageEvent>, window: Window, iframeId: string): Generator<import("redux-saga/effects").ForkEffect<any>, void, unknown>;
    handleCustomScriptsMessage(window: Window, data: IMessage, managementDriver: IManagementDriver, cacheDriver: ICacheDriver, applicationVersion: string, timerStorage: IProprietaryTimerStorage): HandlerResult;
}
