import { CustomScript, CustomScriptResult } from '@signageos/common-types/dist/CustomScript/CustomScript';
interface MessageHandler {
    messageListener: (message: MessageEvent) => void;
    getResult: () => Promise<CustomScriptResult>;
}
/**
 * ProprietaryScriptsHelper contains static methods that are used to facilitate custom scripts execution functionality in browser
 * like create, append, and remove iframe elements.
 */
export default class BrowserRuntimeHelper {
    /**
     * Creates iframe element with absolute position placed at 0, 0 and dimensions set to 0, 0.
     * Page content defined by script string is put into srcdoc.
     * @param {string} script - page content specified as HTML string template
     * @returns {HTMLIFrameElement}
     */
    static createIframe(script: string): HTMLIFrameElement;
    /**
     * Appends given iframe element to document's body.
     * @param {HTMLIFrameElement} iframe
     * @returns {void}
     */
    static appendIframe(iframe: HTMLIFrameElement): void;
    static injectPlatformSpecificAPIs(iframe: HTMLIFrameElement, postResult: (result: string) => void, config: Record<string, any>, apis: Record<string, object>): void;
    static addConfigToSos(): string;
    static createMessageHandler(iframeId: string, postResultID: string): MessageHandler;
    static wrapScript(scriptUrl: string): string;
    static checkIframeWindow: (iframe: HTMLIFrameElement) => void;
    static performCleanUp(messageListener: (message: MessageEvent) => void, iframe: HTMLIFrameElement): void;
    static parseError(script: CustomScript, error: Error): CustomScriptResult;
    /**
     * Returns result of custom script execution.
     * At the time of writing, method always returns result with 'OK - executed'
     * even though there are no guarantees that the script executed successfully.
     * @param {CustomScript} script
     * @returns {CustomScriptResult}
     */
    static getResult(script: CustomScript): CustomScriptResult;
}
export {};
