"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const CACHE_PREFIX = 'default.native_device.cache.';
class ProprietaryCache {
    constructor(storage, defaultTotalSizeBytes) {
        this.storage = storage;
        this.defaultTotalSizeBytes = defaultTotalSizeBytes;
    }
    fetchAllUids() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.storage) {
                const uids = [];
                for (let key in this.storage) {
                    if (key.indexOf(CACHE_PREFIX) === 0) {
                        const uid = key.substring(CACHE_PREFIX.length);
                        uids.push(uid);
                    }
                }
                return uids;
            }
            console.warn(new Error('Not implemented cache get all'));
            return [];
        });
    }
    fetchAll() {
        return new Promise((resolve) => {
            if (this.storage) {
                let contents = {};
                for (let key in this.storage) {
                    if (key.indexOf(CACHE_PREFIX) === 0) {
                        const value = this.storage.getItem(key);
                        const uid = key.substring(CACHE_PREFIX.length);
                        contents[uid] = value;
                    }
                }
                return resolve(contents);
            }
            else {
                console.warn(new Error('Not implemented cache get all'));
                return resolve({});
            }
        });
    }
    fetchOne(uid) {
        return new Promise((resolve, reject) => {
            if (this.storage) {
                const content = this.storage.getItem(CACHE_PREFIX + uid);
                if (content !== null) {
                    resolve(content);
                }
                else {
                    reject(new Error('Content ' + uid + ' was not found'));
                }
            }
            else {
                console.warn(new Error('Not implemented cache get'));
                return reject(new Error('Content ' + uid + ' was not found'));
            }
        });
    }
    deleteOne(uid) {
        if (this.storage) {
            this.storage.removeItem(CACHE_PREFIX + uid);
        }
        else {
            console.warn(new Error('Not implemented cache delete'));
        }
        return Promise.resolve();
    }
    saveOne(uid, content) {
        if (this.storage) {
            if (typeof content === 'undefined') {
                throw new Error(`Store content as undefined is not allowed from uid ${uid}`);
            }
            if (content.length < 1 * 1024 * 1024) {
                this.storage.setItem(CACHE_PREFIX + uid, content);
            }
            else {
                console.warn('Max size for default cache saved content is 1MB');
            }
        }
        else {
            console.warn(new Error('Not implemented cache saveOne'));
        }
        return Promise.resolve();
    }
    getStorageInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            const contents = yield this.fetchAll();
            const usedBytes = Object.keys(contents).reduce(
            // TODO is not real bytes because UTF-8 character can has more then 1 byte (Buffer is not optimized)
            (sum, key) => sum + key.length + (contents[key] ? contents[key].length : 0), 0);
            const totalSizeBytes = Math.max(usedBytes, this.defaultTotalSizeBytes);
            const availableBytes = totalSizeBytes - usedBytes;
            return {
                totalSizeBytes,
                availableBytes,
                usedBytes,
            };
        });
    }
}
exports.default = ProprietaryCache;
//# sourceMappingURL=ProprietaryCache.js.map