import ICache, { IFileContentIndex } from './ICache';
export default class ProprietaryCache implements ICache {
    private storage;
    private defaultTotalSizeBytes;
    constructor(storage: Storage | null, defaultTotalSizeBytes: number);
    fetchAllUids(): Promise<string[]>;
    fetchAll(): Promise<IFileContentIndex>;
    fetchOne(uid: string): Promise<string>;
    deleteOne(uid: string): Promise<void>;
    saveOne(uid: string, content: string): Promise<void>;
    getStorageInfo(): Promise<{
        totalSizeBytes: number;
        availableBytes: number;
        usedBytes: number;
    }>;
}
