"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isUrlInDomain = exports.isUrlAllowed = exports.forbidUrlChangeByAcl = exports.createAclValidator = void 0;
const URL = __importStar(require("url"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Browser:IframeBrowser');
const createAclValidator = (iframe, aclMode, aclDomains, denyCallback, allowCallback) => () => {
    if (!iframe.contentWindow) {
        throw new Error(`New window is not available: ${iframe.src}`);
    }
    debug('load iframe url', iframe.contentWindow.location.href);
    if (!isUrlAllowed(iframe.contentWindow.location.href, aclMode, aclDomains)) {
        denyCallback();
    }
    else {
        allowCallback === null || allowCallback === void 0 ? void 0 : allowCallback();
    }
};
exports.createAclValidator = createAclValidator;
function forbidUrlChangeByAcl(iframe, defaultUri, aclMode, aclDomains, denyCallback) {
    // reinitiate unload listener, when page changed
    const allowCallback = () => forbidUrlChangeByAcl(iframe, defaultUri, aclMode, aclDomains, denyCallback);
    const aclValidator = (0, exports.createAclValidator)(iframe, aclMode, aclDomains, denyCallback, allowCallback);
    if (!iframe.contentWindow) {
        throw new Error(`Current window is not available: ${iframe.src}`);
    }
    const currentContentWindow = iframe.contentWindow;
    const unloadListener = () => {
        // listen only once, because for next page it will be reinitiated
        currentContentWindow.removeEventListener('unload', unloadListener);
        debug('unload iframe url', currentContentWindow.location.href);
        setTimeout(aclValidator, 0); // wait a tick when iframe has new URL already
    };
    iframe.contentWindow.addEventListener('unload', unloadListener);
}
exports.forbidUrlChangeByAcl = forbidUrlChangeByAcl;
function isUrlAllowed(url, aclMode, aclDomains) {
    if (!url) {
        return false;
    }
    const urlMatchRules = (aclDomains === null || aclDomains === void 0 ? void 0 : aclDomains.findIndex((aclDomain) => isUrlInDomain(url, aclDomain))) > -1;
    return aclMode === 'blacklist' ? !urlMatchRules : urlMatchRules;
}
exports.isUrlAllowed = isUrlAllowed;
function isUrlInDomain(url, domain) {
    const parsedUrl = URL.parse(url);
    const urlDomain = parsedUrl.hostname; // excluding port
    return urlDomain === null || urlDomain === void 0 ? void 0 : urlDomain.endsWith(domain);
}
exports.isUrlInDomain = isUrlInDomain;
//# sourceMappingURL=iframeHelper.js.map