import { IHTMLElementProducer } from '../HTML/IHTMLElementProducer';
import IBrowser, { Event, EventType, IOpenLinkOptions } from '../NativeDevice/IBrowser';
/**
 * Implements Browser API via opening a new browser window
 */
export default class WindowBrowser implements IBrowser, IHTMLElementProducer {
    private window;
    private openedWindow;
    private events;
    private internalEvents;
    constructor(window: Window);
    addListener<TType extends EventType>(type: TType, cb: (event: Event<TType>) => void): void;
    removeListener<TType extends EventType>(type: TType, cb: (event: Event<TType>) => void): void;
    open(uri: string, options?: IOpenLinkOptions): Promise<void>;
    close(): Promise<void>;
    onElementCreated(listener: (element: HTMLElement) => void): void;
    isSupported(): Promise<boolean>;
}
