"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const DEBUG_NAMESPACE = '@signageos/front-display:Browser:PolymorphicBrowser';
/**
 * Polymorphic browser combines multiple Browser implementations and allows selection via "method" option
 *
 * This is required on some platforms that implement multiple ways to open browser with different features and limitations.
 */
class PolymorphicBrowser {
    constructor(browsers) {
        this.browsers = browsers;
    }
    open(uri, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.browsers.length === 0) {
                throw new Error('no browser methods');
            }
            let index = -1;
            if (options === null || options === void 0 ? void 0 : options.method) {
                index = this.findBrowserIndexByMethod(options.method);
            }
            // if method not specified or not found, fallback to the first browser, which is default
            if (index < 0) {
                index = 0;
            }
            // to make it as smooth as possible, first open new browser and then close all others
            // only one browser can be open at a time
            yield this.browsers[index].browser.open(uri, options);
            yield this.closeAllBut(index);
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            for (const browser of this.browsers) {
                yield browser.browser.close();
            }
        });
    }
    addListener(type, listener) {
        for (const browser of this.browsers) {
            browser.browser.addListener(type, listener);
        }
    }
    removeListener(type, listener) {
        for (const browser of this.browsers) {
            browser.browser.removeListener(type, listener);
        }
    }
    isSupported() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.browsers.length > 0;
        });
    }
    findBrowserIndexByMethod(method) {
        return this.browsers.findIndex((browser) => browser.method === method);
    }
    closeAllBut(index) {
        return __awaiter(this, void 0, void 0, function* () {
            for (let i = 0; i < this.browsers.length; i++) {
                if (i !== index) {
                    yield this.browsers[i].browser.close();
                }
            }
        });
    }
}
exports.default = PolymorphicBrowser;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], PolymorphicBrowser.prototype, "open", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PolymorphicBrowser.prototype, "close", null);
//# sourceMappingURL=PolymorphicBrowser.js.map