import IBrowser, { Event, EventType, IOpenLinkOptions } from '../NativeDevice/IBrowser';
export type BrowserMethod = {
    method: string;
    browser: IBrowser;
};
/**
 * Polymorphic browser combines multiple Browser implementations and allows selection via "method" option
 *
 * This is required on some platforms that implement multiple ways to open browser with different features and limitations.
 */
export default class PolymorphicBrowser implements IBrowser {
    private browsers;
    constructor(browsers: BrowserMethod[]);
    open(uri: string, options?: IOpenLinkOptions): Promise<void>;
    close(): Promise<void>;
    addListener<TType extends EventType>(type: TType, listener: (event: Event<TType>) => void): void;
    removeListener<TType extends EventType>(type: TType, listener: (event: Event<TType>) => void): void;
    isSupported(): Promise<boolean>;
    private findBrowserIndexByMethod;
    private closeAllBut;
}
