import { IHTMLElementProducer } from '../HTML/IHTMLElementProducer';
import IBrowser, { Event, EventType, IOpenLinkOptions } from '../NativeDevice/IBrowser';
/**
 * Implements Browser API via iframes
 */
export default class IframeBrowser implements IBrowser, IHTMLElementProducer {
    private window;
    private iframe;
    private aclInterval;
    private events;
    private internalEvents;
    constructor(window: Window);
    open(uri: string, options?: IOpenLinkOptions): Promise<void>;
    close(): Promise<void>;
    addListener<TType extends EventType>(eventName: TType, listener: (event: Event<TType>) => void): void;
    removeListener<TType extends EventType>(eventName: TType, listener: (event: Event<TType>) => void): void;
    onElementCreated(listener: (element: HTMLElement) => void): void;
    isSupported(): Promise<boolean>;
    private createFullscreenIframe;
    private createWindowedIframe;
    private createBaseIframe;
    private removeIframe;
}
