"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.authentication = void 0;
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const initialState = {
    authenticated: false,
    authenticating: false,
    failReason: null,
    revoking: false,
};
function authentication(state = initialState, action) {
    switch (action.type) {
        case authenticationActions_1.AuthenticateDevice:
            return Object.assign(Object.assign({}, state), { authenticating: true, failReason: null });
        case authenticationActions_1.AuthenticationSucceed:
            return Object.assign(Object.assign({}, state), { authenticated: true, authenticating: false, failReason: null });
        case authenticationActions_1.NewSessionStored:
            return Object.assign(Object.assign({}, state), { authenticated: true });
        case authenticationActions_1.AuthenticationFailed:
            return Object.assign(Object.assign({}, state), { authenticating: false, failReason: action.reason });
        case authenticationActions_1.RevokeDevice:
            return Object.assign(Object.assign({}, state), { revoking: true });
        case authenticationActions_1.RevokeSucceed:
            return Object.assign(Object.assign({}, state), { authenticated: false, revoking: false });
        default:
            return state;
    }
}
exports.authentication = authentication;
//# sourceMappingURL=authenticationReducers.js.map