"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createActionForwardMiddleware = exports.actionEmitterMiddleware = void 0;
const property_1 = require("../Object/property");
const events_1 = require("events");
const actionEmitterMiddleware = (_store) => (next) => (action) => {
    (0, property_1.defineInvisibleProperty)(action, '__emitter', new events_1.EventEmitter());
    return next(action);
};
exports.actionEmitterMiddleware = actionEmitterMiddleware;
const createActionForwardMiddleware = (emitter) => (_store) => (next) => (action) => {
    emitter.emit(action.type, action);
    return next(action);
};
exports.createActionForwardMiddleware = createActionForwardMiddleware;
//# sourceMappingURL=applicationMiddlewares.js.map