import { ICopyFileOptions, IFile, IFilePath, IHeaders, IMoveFileOptions, IStorageUnit } from "../../FrontApplet/FileSystem/types";
export declare type FileSystemRequests = FileSystemListOfStorageUnitsRequest | FileSystemListFilesRequest | FileSystemIsDirectoryRequest | FileSystemExistsRequest | FileSystemDeleteFileRequest | FileSystemCreateDirectoryRequest | FileSystemDownloadFileRequest | FileSystemWriteFileRequest | FileSystemReadFileRequest | FileSystemMoveFileRequest | FileSystemCopyFileRequest | FileSystemGetFileChecksumRequest | FileSystemExtractFileRequest | FileSystemGetFileRequest | FileSystemAppendFileRequest | FileSystemCreateArchiveFileRequest;
export declare const FileSystemListOfStorageUnitsRequest = "sos.Monitoring.FileSystem.FileSystemListOfStorageUnitsRequest";
export interface FileSystemListOfStorageUnitsRequest {
    type: typeof FileSystemListOfStorageUnitsRequest;
}
export declare const FileSystemListOfStorageUnitsResult = "sos.Monitoring.FileSystem.FileSystemListOfStorageUnitsResult";
export interface FileSystemListOfStorageUnitsResult {
    type: typeof FileSystemListOfStorageUnitsResult;
    storageUnits: IStorageUnit[];
}
export declare const FileSystemListFilesRequest = "sos.Monitoring.FileSystem.FileSystemListFilesRequest";
export interface FileSystemListFilesRequest {
    type: typeof FileSystemListFilesRequest;
    filePath: IFilePath;
}
export declare const FileSystemListFilesResult = "sos.Monitoring.FileSystem.FileSystemListFilesResult";
export interface FileSystemListFilesResult {
    type: typeof FileSystemListFilesResult;
    pathList: IFilePath[];
}
export declare const FileSystemIsDirectoryRequest = "sos.Monitoring.FileSystem.FileSystemIsDirectoryRequest";
export interface FileSystemIsDirectoryRequest {
    type: typeof FileSystemIsDirectoryRequest;
    filePath: IFilePath;
}
export declare const FileSystemIsDirectoryResult = "sos.Monitoring.FileSystem.FileSystemIsDirectoryResult";
export interface FileSystemIsDirectoryResult {
    type: typeof FileSystemIsDirectoryResult;
    result: boolean;
}
export declare const FileSystemExistsRequest = "sos.Monitoring.FileSystem.FileSystemExistsRequest";
export interface FileSystemExistsRequest {
    type: typeof FileSystemExistsRequest;
    filePath: IFilePath;
}
export declare const FileSystemExistsResult = "sos.Monitoring.FileSystem.FileSystemExistsResult";
export interface FileSystemExistsResult {
    type: typeof FileSystemExistsResult;
    result: boolean;
}
export declare const FileSystemDeleteFileRequest = "sos.Monitoring.FileSystem.FileSystemDeleteFileRequest";
export interface FileSystemDeleteFileRequest {
    type: typeof FileSystemDeleteFileRequest;
    filePath: IFilePath;
    recursive: boolean;
}
export declare const FileSystemDeleteFileResult = "sos.Monitoring.FileSystem.FileSystemDeleteFileResult";
export interface FileSystemDeleteFileResult {
    type: typeof FileSystemDeleteFileResult;
    result: void;
}
export declare const FileSystemCreateDirectoryRequest = "sos.Monitoring.FileSystem.FileSystemCreateDirectoryRequest";
export interface FileSystemCreateDirectoryRequest {
    type: typeof FileSystemCreateDirectoryRequest;
    directoryPath: IFilePath;
}
export declare const FileSystemCreateDirectoryResult = "sos.Monitoring.FileSystem.FileSystemCreateDirectoryResult";
export interface FileSystemCreateDirectoryResult {
    type: typeof FileSystemCreateDirectoryResult;
    result: void;
}
export declare const FileSystemDownloadFileRequest = "sos.Monitoring.FileSystem.FileSystemDownloadFileRequest";
export interface FileSystemDownloadFileRequest {
    type: typeof FileSystemDownloadFileRequest;
    filePath: IFilePath;
    sourceUri: string;
    headers?: IHeaders | undefined;
}
export declare const FileSystemDownloadFileResult = "sos.Monitoring.FileSystem.FileSystemDownloadFileResult";
export interface FileSystemDownloadFileResult {
    type: typeof FileSystemDownloadFileResult;
    result: void;
}
export declare const FileSystemWriteFileRequest = "sos.Monitoring.FileSystem.FileSystemWriteFileRequest";
export interface FileSystemWriteFileRequest {
    type: typeof FileSystemWriteFileRequest;
    filePath: IFilePath;
    content: string;
}
export declare const FileSystemWriteFileResult = "sos.Monitoring.FileSystem.FileSystemWriteFileResult";
export interface FileSystemWriteFileResult {
    type: typeof FileSystemWriteFileResult;
    result: void;
}
export declare const FileSystemReadFileRequest = "sos.Monitoring.FileSystem.FileSystemReadFileRequest";
export interface FileSystemReadFileRequest {
    type: typeof FileSystemReadFileRequest;
    filePath: IFilePath;
}
export declare const FileSystemReadFileResult = "sos.Monitoring.FileSystem.FileSystemReadFileResult";
export interface FileSystemReadFileResult {
    type: typeof FileSystemReadFileResult;
    data: string;
}
export declare const FileSystemMoveFileRequest = "sos.Monitoring.FileSystem.FileSystemMoveFileRequest";
export interface FileSystemMoveFileRequest {
    type: typeof FileSystemMoveFileRequest;
    sourceFilePath: IFilePath;
    destinationFilePath: IFilePath;
    options: IMoveFileOptions | {};
}
export declare const FileSystemMoveFileResult = "sos.Monitoring.FileSystem.FileSystemMoveFileResult";
export interface FileSystemMoveFileResult {
    type: typeof FileSystemMoveFileResult;
    result: void;
}
export declare const FileSystemCopyFileRequest = "sos.Monitoring.FileSystem.FileSystemCopyFileRequest";
export interface FileSystemCopyFileRequest {
    type: typeof FileSystemCopyFileRequest;
    sourceFilePath: IFilePath;
    destinationFilePath: IFilePath;
    options: ICopyFileOptions | {};
}
export declare const FileSystemCopyFileResult = "sos.Monitoring.FileSystem.FileSystemCopyFileResult";
export interface FileSystemCopyFileResult {
    type: typeof FileSystemCopyFileResult;
    result: void;
}
export declare const FileSystemGetFileChecksumRequest = "sos.Monitoring.FileSystem.FileSystemGetFileChecksumRequest";
export interface FileSystemGetFileChecksumRequest {
    type: typeof FileSystemGetFileChecksumRequest;
    filePath: IFilePath;
    hashType: string;
}
export declare const FileSystemGetFileChecksumResult = "sos.Monitoring.FileSystem.FileSystemGetFileChecksumResult";
export interface FileSystemGetFileChecksumResult {
    type: typeof FileSystemGetFileChecksumResult;
    result: string;
}
export declare const FileSystemExtractFileRequest = "sos.Monitoring.FileSystem.FileSystemExtractFileRequest";
export interface FileSystemExtractFileRequest {
    type: typeof FileSystemExtractFileRequest;
    archiveFilePath: IFilePath;
    destinationDirectionPath: IFilePath;
    method: string;
}
export declare const FileSystemCreateArchiveFileRequest = "sos.Monitoring.FileSystem.FileSystemCreateArchiveFileRequest";
export interface FileSystemCreateArchiveFileRequest {
    type: typeof FileSystemCreateArchiveFileRequest;
    archiveFilePath: IFilePath;
    archiveEntries: IFilePath[];
}
export declare const FileSystemCreateArchiveFileResult = "sos.Monitoring.FileSystem.FileSystemCreateArchiveFileResult";
export interface FileSystemCreateArchiveFileResult {
    type: typeof FileSystemCreateArchiveFileResult;
    result: void;
}
export declare const FileSystemExtractFileResult = "sos.Monitoring.FileSystem.FileSystemExtractFileResult";
export interface FileSystemExtractFileResult {
    type: typeof FileSystemExtractFileResult;
    result: void;
}
export declare const FileSystemGetFileRequest = "sos.Monitoring.FileSystem.FileSystemGetFileRequest";
export interface FileSystemGetFileRequest {
    type: typeof FileSystemGetFileRequest;
    filePath: IFilePath;
}
export declare const FileSystemGetFileResult = "sos.Monitoring.FileSystem.FileSystemGetFileResult";
export interface FileSystemGetFileResult {
    type: typeof FileSystemGetFileResult;
    file: IFile | null;
}
export declare const FileSystemAppendFileRequest = "sos.Monitoring.FileSystem.FileSystemAppendFileRequest";
export interface FileSystemAppendFileRequest {
    type: typeof FileSystemAppendFileRequest;
    filePath: IFilePath;
    content: string;
}
export declare const FileSystemAppendFileResult = "sos.Monitoring.FileSystem.FileSystemAppendFileResult";
export interface FileSystemAppendFileResult {
    type: typeof FileSystemAppendFileResult;
    result: void;
}
