import IVideoEventListener from './IVideoEventListener';
import IPostMessage from '../IPostMessage';
import IVideoMessage from './IVideoMessage';
import { IOptions } from './IOptions';
export default class Video {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    private onceDeferredIndex;
    constructor(messagePrefix: string, postMessage: IPostMessage<void>);
    play(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IOptions): Promise<void>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    /**
     * Promise is resolved once the currently playing video is ended
     * Promise is rejected when currently playing video is stopped before it's ended (so in case the video will never end)
     */
    onceEnded(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    onceStop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    onPlay(listener: IVideoEventListener): void;
    onPrepare(listener: IVideoEventListener): void;
    onStop(listener: IVideoEventListener): void;
    onPause(listener: IVideoEventListener): void;
    onResume(listener: IVideoEventListener): void;
    onEnded(listener: IVideoEventListener): void;
    onError(listener: IVideoEventListener): void;
    handleMessageData(data: IVideoMessage): void;
    removeEventListeners(): void;
    private createOncePromise;
    private getMessage;
    private removeAllVideoListeners;
    private createAndEmitEvent;
    private checkParamsValidity;
}
