"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringifySrcArguments = exports.getEventName = exports.VIDEO_EVENT_TYPES = void 0;
exports.VIDEO_EVENT_TYPES = [
    'prepare', 'play', 'stop', 'pause', 'resume', 'ended', 'error',
];
function getEventName(event) {
    const srcArgumentsString = stringifySrcArguments(event.srcArguments.uri, event.srcArguments.x, event.srcArguments.y, event.srcArguments.width, event.srcArguments.height);
    return `${event.type}_${srcArgumentsString}`;
}
exports.getEventName = getEventName;
function stringifySrcArguments(uri, x, y, width, height) {
    return `${uri}$${x}_${y}_${width}_${height}`;
}
exports.stringifySrcArguments = stringifySrcArguments;
//# sourceMappingURL=IVideoEvent.js.map