import ErrorCodes from "../Error/ErrorCodes";
interface IOutsideValidationSubject {
    [key: string]: any;
}
export interface IValidationSubject {
    name: string;
    subject: any;
}
export declare const validatableType: readonly ["string", "number", "boolean", "function", "object", "undefined", "null", "array"];
export declare type ValidatableType = typeof validatableType[number];
export declare class Validate {
    private validationSubject;
    private error;
    private _canBeNull;
    static oneOfPossibleTypesIsType(types: ValidatableType | ValidatableType[], type: ValidatableType): boolean;
    static validateType(types: ValidatableType | ValidatableType[], subject: any): string | true;
    static validateSingleType(type: ValidatableType, subject: any): true | "string" | "number" | "bigint" | "boolean" | "symbol" | "undefined" | "object" | "function";
    constructor(validationSubject: IOutsideValidationSubject);
    canBeNull(): this;
    setError(error: Error): this;
    required(errorCode?: ErrorCodes): this;
    boolean(errorCode?: ErrorCodes): this;
    number(errorCode?: ErrorCodes): this;
    min(min: number, errorCode?: ErrorCodes): this;
    max(max: number, errorCode?: ErrorCodes): this;
    string(equals?: (string | undefined)[] | null, errorCode?: ErrorCodes): this;
    lengthMin(lengthMin: number, errorCode?: ErrorCodes): this;
    lengthMax(lengthMax: number, errorCode?: ErrorCodes): this;
    object(objectInterface?: object, errorCode?: ErrorCodes): this;
    array(types: ValidatableType | ValidatableType[], objectInterface?: object, errorCode?: ErrorCodes): this;
    function(errorCode?: ErrorCodes): this;
    date(errorCode?: ErrorCodes): this;
    uri(errorCode?: ErrorCodes): this;
    matchRegExp(regexp: RegExp, errorCode?: ErrorCodes): this;
    timerTime(errorCode?: ErrorCodes): this;
    own(callback: (validationSubject: IValidationSubject) => string | true, errorCode?: ErrorCodes): this;
    throwError(message: string, errorCode?: ErrorCodes): void;
    canBeNullAndIs(): boolean;
    private getSubjectFromOutside;
    private checkObjectInterface;
}
export default function validate(validationSubject: IOutsideValidationSubject): Validate;
export {};
