"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Touch {
    constructor(window, messagePrefix, postMessageToParent) {
        this.window = window;
        this.messagePrefix = messagePrefix;
        this.postMessageToParent = postMessageToParent;
        const handleTouch = (event) => this.handleTouch(event);
        this.window.addEventListener('touchstart', handleTouch, true);
        this.window.addEventListener('touchend', handleTouch, true);
        this.window.addEventListener('touchcancel', handleTouch, true);
        this.window.addEventListener('touchmove', handleTouch, true);
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('propagate'):
                const elementToClick = this.window.document.elementFromPoint(data.x, data.y);
                if (elementToClick && "click" in elementToClick) {
                    elementToClick.click();
                }
                break;
            default:
        }
    }
    transformIframeData(originalData, targetWindow) {
        if (originalData.type !== this.getMessage('propagate')) {
            return originalData;
        }
        const detectedIframes = Array.from(this.window.document.getElementsByTagName('iframe'));
        const targetIframe = detectedIframes.find((iframe) => {
            return iframe.contentWindow === targetWindow;
        });
        if (typeof targetIframe === 'undefined' ||
            originalData.x < targetIframe.offsetLeft ||
            originalData.x > targetIframe.offsetLeft + targetIframe.offsetWidth ||
            originalData.y < targetIframe.offsetTop ||
            originalData.y > targetIframe.offsetTop + targetIframe.offsetHeight) {
            return undefined;
        }
        return Object.assign(Object.assign({}, originalData), { x: originalData.x - targetIframe.offsetLeft, y: originalData.y - targetIframe.offsetTop });
    }
    handleTouch(event) {
        this.postMessageToParent({
            type: this.getMessage('event'),
            eventType: event.type,
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Touch.MESSAGE_PREFIX + '.' + name;
    }
}
exports.default = Touch;
Touch.MESSAGE_PREFIX = 'touch';
//# sourceMappingURL=Touch.js.map