import IPostMessage from '../IPostMessage';
import StreamProtocol from './StreamProtocol';
import IStreamMessage from './IStreamMessage';
import IStreamEventListener from './IStreamEventListener';
import { IStreamOptions } from '../Video/IOptions';
export default class Stream {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<void>);
    prepare(uri: string, x: number, y: number, width: number, height: number, protocol: keyof typeof StreamProtocol, options?: IStreamOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number, protocol?: keyof typeof StreamProtocol, options?: IStreamOptions): Promise<void>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    onError(listener: IStreamEventListener<'error'>): void;
    onConnected(listener: IStreamEventListener<'connected'>): void;
    onDisconnected(listener: IStreamEventListener<'disconnected'>): void;
    onPrepare(listener: IStreamEventListener<'prepare'>): void;
    onPlay(listener: IStreamEventListener<'play'>): void;
    onStop(listener: IStreamEventListener<'stop'>): void;
    handleMessageData(data: IStreamMessage): void;
    removeEventListeners(): void;
    private createAndEmitEvent;
    private getMessage;
    private checkParamsValidity;
}
